unit Jelolo1u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Sugar: TEdit;
    KerTer: TCheckBox;
    Label2: TLabel;
    Eredmeny: TEdit;
    Kilepes: TButton;
    procedure KilepesClick(Sender: TObject);
    procedure SugarChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    R : real;  // a kr sugara
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function Str2Dbl(const s: string):double;
var  dc : char;
begin
  dc := decimalseparator;
  if pos(',',s) <> 0 then
    decimalseparator := ','
  else
    decimalseparator := '.';
  try
     Str2Dbl := strToFloat(s);
  except
     Str2Dbl := 0;
  end;
  decimalseparator := dc;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   KerTer.State := CbChecked;
   Eredmeny.ReadOnly := true; // a szvegmez csak olvashat
   Eredmeny.Text := '';
end;

procedure TForm1.SugarChange(Sender: TObject);
begin
    R := Str2Dbl(Sugar.Text);
    if R > 0 then
    begin
      if KerTer.State = CbChecked then
      begin
        Label2.Caption := 'A kr terlete';
        Eredmeny.Text  := FloatToStr(sqr(R)*pi);
      end
      else
      begin
        Label2.Caption := 'A kr kerlete';
        Eredmeny.Text  := FloatToStr(2*R*pi);
      end;
    end
   else
    Eredmeny.Text  := '';
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
  Application.Terminate;
end;
end.
